#include <bits/stdc++.h>
using namespace std;

using ll = long long;

ll comb2(ll x) {
    if (x < 2) return 0;
    return x * (x - 1) / 2;
}

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int N;
    cin >> N;

    vector<pair<ll,ll>> pts(N);
    for (int i = 0; i < N; i++) {
        cin >> pts[i].first >> pts[i].second;
    }

    ll ans = 0;


    unordered_map<ll, pair<ll,ll>> mpX;
    for (auto &p : pts) {
        ll x = p.first, y = p.second;
        if (y % 2 == 0) mpX[x].first++;
        else mpX[x].second++;
    }
    for (auto &it : mpX) {
        ans += comb2(it.second.first);
        ans += comb2(it.second.second);
    }


    unordered_map<ll, pair<ll,ll>> mpY;
    for (auto &p : pts) {
        ll x = p.first, y = p.second;
        if (x % 2 == 0) mpY[y].first++;
        else mpY[y].second++;
    }
    for (auto &it : mpY) {
        ans += comb2(it.second.first);
        ans += comb2(it.second.second);
    }


    unordered_map<ll, ll> mpDiag1;
    for (auto &p : pts) {
        mpDiag1[p.first + p.second]++;
    }
    for (auto &it : mpDiag1) {
        ans += 2 * comb2(it.second);
    }


    unordered_map<ll, ll> mpDiag2;
    for (auto &p : pts) {
        mpDiag2[p.first - p.second]++;
    }
    for (auto &it : mpDiag2) {
        ans += 2 * comb2(it.second);
    }

    cout << ans << "\n";
    return 0;
}